<?php
// Fichier de test pour vérifier que l'API fonctionne correctement
header('Content-Type: application/json');

// Activer l'affichage des erreurs pour le débogage
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Créer un fichier de log pour le débogage
$logFile = __DIR__ . '/test_api.log';
file_put_contents($logFile, "=== Test API exécuté le " . date('Y-m-d H:i:s') . " ===\n", FILE_APPEND);

// Tester l'accès à l'API Google Maps
$apiKey = 'AIzaSyAjsOoV0528RtrLFvylBrsypk0Z3qik5RI';
$testUrl = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=-21.115141,55.536384&destinations=-21.215141,55.636384&mode=driving&language=fr&key=" . $apiKey;

try {
    // Initialise une requête cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $testUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_errno($ch)) {
        $error = 'cURL Error: ' . curl_error($ch);
        file_put_contents($logFile, "ERREUR: $error\n", FILE_APPEND);
        echo json_encode(['success' => false, 'error' => $error]);
    } else {
        file_put_contents($logFile, "Code HTTP: $httpCode\n", FILE_APPEND);
        file_put_contents($logFile, "Réponse: " . substr($response, 0, 500) . "...\n", FILE_APPEND);
        
        $data = json_decode($response, true);
        if ($data && isset($data['status']) && $data['status'] === 'OK') {
            echo json_encode([
                'success' => true, 
                'message' => 'API Google Maps fonctionne correctement',
                'status' => $data['status'],
                'distance' => $data['rows'][0]['elements'][0]['distance']['text'] ?? 'Non disponible'
            ]);
        } else {
            echo json_encode([
                'success' => false, 
                'message' => 'Erreur dans la réponse de l\'API Google Maps',
                'status' => $data['status'] ?? 'Inconnu',
                'error_message' => $data['error_message'] ?? 'Pas de message d\'erreur'
            ]);
        }
    }
    
    curl_close($ch);
} catch (Exception $e) {
    file_put_contents($logFile, "Exception: " . $e->getMessage() . "\n", FILE_APPEND);
    echo json_encode(['success' => false, 'error' => 'Exception: ' . $e->getMessage()]);
}
